package com.biz.crm.sfa.worksign.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelUserReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelUserRespVo;
import com.biz.crm.sfa.worksign.SfaTravelUserFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 出差人员表 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Slf4j
@Component
public class SfaTravelUserFeignImpl extends BaseAbstract implements FallbackFactory<SfaTravelUserFeign> {

    @Override
    public SfaTravelUserFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaTravelUserFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaTravelUserRespVo>> list(SfaTravelUserReqVo sfaTravelUserReqVo) {
                doBack();
                PageResult<SfaTravelUserRespVo> build = PageResult.<SfaTravelUserRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaTravelUserRespVo> query(SfaTravelUserReqVo sfaTravelUserReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaTravelUserReqVo sfaTravelUserReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaTravelUserReqVo sfaTravelUserReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaTravelUserReqVo sfaTravelUserReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaTravelUserReqVo sfaTravelUserReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaTravelUserReqVo sfaTravelUserReqVo) {
                return doBack();
            }
        };
    }
}
