package com.biz.crm.sfa.worksignrule;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPlaceReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPlaceRespVo;
import com.biz.crm.sfa.worksignrule.impl.SfaWorkSignPlaceFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 考勤规则-打卡地点 feign接口
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignPlaceFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignPlaceFeignImpl.class)
public interface SfaWorkSignPlaceFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworksignplace/list")
    Result<PageResult<SfaWorkSignPlaceRespVo>> list(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworksignplace/query")
    Result<SfaWorkSignPlaceRespVo> query(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworksignplace/save")
    Result save(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworksignplace/update")
    Result update(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworksignplace/delete")
    Result delete(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworksignplace/enable")
    Result enable(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworksignplace/disable")
    Result disable(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);
}
