package com.biz.crm.sfa.worksignrule.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignTimeReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignTimeRespVo;
import com.biz.crm.sfa.worksignrule.SfaWorkSignTimeFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 考勤规则-打卡时间;feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Slf4j
@Component
public class SfaWorkSignTimeFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkSignTimeFeign> {

    @Override
    public SfaWorkSignTimeFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkSignTimeFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkSignTimeRespVo>> list(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
                doBack();
                PageResult<SfaWorkSignTimeRespVo> build = PageResult.<SfaWorkSignTimeRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkSignTimeRespVo> query(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
                return doBack();
            }
        };
    }
}
