package com.biz.crm.tpm.account.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailMainReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountUpdatePayTypeReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailMainRespVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailRespVo;
import com.biz.crm.tpm.account.TpmAccountDetailFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.ArrayList;

/**
 * 费用上账表;feign接口熔断类
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Slf4j
@Component
public class TpmAccountDetailFeignImpl extends BaseAbstract implements FallbackFactory<TpmAccountDetailFeign> {

    @Override
    public TpmAccountDetailFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmAccountDetailFeign() {
             /**
              * 列表
              */
            @PostMapping("/tpmaccountdetail/list")
            @Override
            public Result<PageResult<TpmAccountDetailRespVo>> list(TpmAccountDetailReqVo tpmAccountDetailReqVo) {
                doBack();
                PageResult<TpmAccountDetailRespVo> build = PageResult.<TpmAccountDetailRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmAccountDetailMainRespVo> queryView(TpmAccountDetailReqVo tpmAccountDetailReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmAccountDetailReqVo tpmAccountDetailReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmAccountDetailReqVo tpmAccountDetailReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmAccountDetailReqVo tpmAccountDetailReqVo) {
                return doBack();
            }

            /**
             * 批量修改支付方式
             * @param accountUpdatePayTypeReqVo
             * @return
             */
            @Override
            public Result batchUpdatePayType(TpmAccountUpdatePayTypeReqVo accountUpdatePayTypeReqVo) {
                return doBack();
            }
        };
    }
}
