package com.biz.crm.tpm.act;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.act.impl.TpmActDetailFeignImpl;

/**
 * 活动明细信息表;feign接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmActDetailFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmActDetailFeignImpl.class)
public interface TpmActDetailFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmactdetail/list")
    Result<PageResult<TpmActDetailRespVo>> list(@RequestBody TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 活动预付查询活动明细
     */
    @PostMapping("/tpmactdetail/pageForAdvancePay")
    Result<PageResult<TpmActDetailRespVo>> pageForAdvancePay(@RequestBody TpmActDetailReqVo tpmActDetailReqVo);



    /**
     * 查询
     */
    @PostMapping("/tpmactdetail/query")
    Result<TpmActDetailRespVo> query(@RequestBody TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmactdetail/save")
    Result save(@RequestBody TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmactdetail/update")
    Result update(@RequestBody TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmactdetail/delete")
    Result delete(@RequestBody TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmactdetail/enable")
    Result enable(@RequestBody TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmactdetail/disable")
    Result disable(@RequestBody TpmActDetailReqVo tpmActDetailReqVo);
}
