package com.biz.crm.tpm.act;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.act.resp.TpmActFileRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActFileReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.act.impl.TpmActFileFeignImpl;

/**
 * 活动附件信息;feign接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmActFileFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmActFileFeignImpl.class)
public interface TpmActFileFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmactfile/list")
    Result<PageResult<TpmActFileRespVo>> list(@RequestBody TpmActFileReqVo tpmActFileReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmactfile/query")
    Result<TpmActFileRespVo> query(@RequestBody TpmActFileReqVo tpmActFileReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmactfile/save")
    Result save(@RequestBody TpmActFileReqVo tpmActFileReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmactfile/update")
    Result update(@RequestBody TpmActFileReqVo tpmActFileReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmactfile/delete")
    Result delete(@RequestBody TpmActFileReqVo tpmActFileReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmactfile/enable")
    Result enable(@RequestBody TpmActFileReqVo tpmActFileReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmactfile/disable")
    Result disable(@RequestBody TpmActFileReqVo tpmActFileReqVo);
}
