package com.biz.crm.tpm.actfieldcollect.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.actfieldcollect.req.TpmActCollectFieldReqVo;
import com.biz.crm.nebular.tpm.actfieldcollect.resp.TpmActCollectFieldRespVo;
import com.biz.crm.tpm.actfieldcollect.TpmActCollectFieldFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 活动采集字段表;feign接口熔断类
 *
 * @author zeyi
 * @date 2020-11-03 13:42:29
 */
@Slf4j
@Component
public class TpmActCollectFieldFeignImpl extends BaseAbstract implements FallbackFactory<TpmActCollectFieldFeign> {

    @Override
    public TpmActCollectFieldFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmActCollectFieldFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmActCollectFieldRespVo>> list(TpmActCollectFieldReqVo tpmActCollectFieldReqVo) {
                doBack();
                PageResult<TpmActCollectFieldRespVo> build = PageResult.<TpmActCollectFieldRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmActCollectFieldRespVo> query(TpmActCollectFieldReqVo tpmActCollectFieldReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmActCollectFieldReqVo tpmActCollectFieldReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmActCollectFieldReqVo tpmActCollectFieldReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmActCollectFieldReqVo tpmActCollectFieldReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmActCollectFieldReqVo tpmActCollectFieldReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmActCollectFieldReqVo tpmActCollectFieldReqVo) {
                return doBack();
            }
        };
    }
}
