package com.biz.crm.tpm.advancepay;

import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.advancepay.impl.TpmActAdvancePayFeignImpl;

/**
 * 活动预付主表 feign接口
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmActAdvancePayFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmActAdvancePayFeignImpl.class)
public interface TpmActAdvancePayFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmactadvancepay/list")
    Result<PageResult<TpmActAdvancePayRespVo>> list(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmactadvancepay/query")
    Result<TpmActAdvancePayRespVo> query(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmactadvancepay/save")
    Result save(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmactadvancepay/update")
    Result update(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmactadvancepay/delete")
    Result delete(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmactadvancepay/enable")
    Result enable(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmactadvancepay/disable")
    Result disable(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo);

    /**
     * 提交审批
     */
    @PostMapping("/tpmactadvancepay/approve")
    Result approve(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo);
}
