package com.biz.crm.tpm.advancepay.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayDetailRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayDetailReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.advancepay.TpmActAdvancePayDetailFeign;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 活动预付明细表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
@Slf4j
@Component
public class TpmActAdvancePayDetailFeignImpl extends BaseAbstract implements FallbackFactory<TpmActAdvancePayDetailFeign> {

    @Override
    public TpmActAdvancePayDetailFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmActAdvancePayDetailFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmActAdvancePayDetailRespVo>> list(TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo) {
                doBack();
                PageResult<TpmActAdvancePayDetailRespVo> build = PageResult.<TpmActAdvancePayDetailRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmActAdvancePayDetailRespVo> query(TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo) {
                return doBack();
            }
        };
    }
}
