package com.biz.crm.tpm.advancepay.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.advancepay.TpmActAdvancePayFeign;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 活动预付主表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
@Slf4j
@Component
public class TpmActAdvancePayFeignImpl extends BaseAbstract implements FallbackFactory<TpmActAdvancePayFeign> {

    @Override
    public TpmActAdvancePayFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmActAdvancePayFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmActAdvancePayRespVo>> list(TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
                doBack();
                PageResult<TpmActAdvancePayRespVo> build = PageResult.<TpmActAdvancePayRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmActAdvancePayRespVo> query(TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
                return doBack();
            }

            @Override
            public Result approve(TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
                return doBack();
            }
        };
    }
}
