package com.biz.crm.tpm.audit;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.audit.impl.TpmAuditFileFeignImpl;

/**
 * 核销申请资料表 feign接口
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmAuditFileFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmAuditFileFeignImpl.class)
public interface TpmAuditFileFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmauditfile/list")
    Result<PageResult<TpmAuditFileRespVo>> list(@RequestBody TpmAuditFileReqVo tpmAuditFileReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmauditfile/query")
    Result<TpmAuditFileRespVo> query(@RequestBody TpmAuditFileReqVo tpmAuditFileReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmauditfile/save")
    Result save(@RequestBody TpmAuditFileReqVo tpmAuditFileReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmauditfile/update")
    Result update(@RequestBody TpmAuditFileReqVo tpmAuditFileReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmauditfile/delete")
    Result delete(@RequestBody TpmAuditFileReqVo tpmAuditFileReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmauditfile/enable")
    Result enable(@RequestBody TpmAuditFileReqVo tpmAuditFileReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmauditfile/disable")
    Result disable(@RequestBody TpmAuditFileReqVo tpmAuditFileReqVo);
}
