package com.biz.crm.tpm.audit.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.tpm.act.TpmActCallBackFeign;
import com.biz.crm.tpm.audit.TpmAuditCallBackFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 核销审批回调;feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Component
public class TpmAuditCallBackFeignImpl extends BaseAbstract implements FallbackFactory<TpmAuditCallBackFeign> {

    @Override
    public TpmAuditCallBackFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmAuditCallBackFeign() {
            @Override
            public Result callback(ActivitiCallBackVo activitiCallBackVo) {
                return doBack();
            }
        };
    }
}
