package com.biz.crm.tpm.audit.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.tpm.audit.TpmLiqueurAuditCallBackFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 酒类核销审批回调;feign接口熔断类
 *
 * @author jerry7
 * @date 2021-03-29 10:46:33
 */
@Slf4j
@Component
public class TpmLiqueurAuditCallBackFeignImpl extends BaseAbstract implements FallbackFactory<TpmLiqueurAuditCallBackFeign> {

    @Override
    public TpmLiqueurAuditCallBackFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new TpmLiqueurAuditCallBackFeign() {
            @Override
            public Result callback(ActivitiCallBackVo activitiCallBackVo) {
                return doBack();
            }
        };
    }
}
