package com.biz.crm.tpm.costtypecategories.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRangeRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesRangeReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.costtypecategories.TpmCostTypeCategoriesRangeFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;

/**
 * 活动大类范围表;feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Slf4j
@Component
public class TpmCostTypeCategoriesRangeFeignImpl extends BaseAbstract implements FallbackFactory<TpmCostTypeCategoriesRangeFeign> {

    @Override
    public TpmCostTypeCategoriesRangeFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmCostTypeCategoriesRangeFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmCostTypeCategoriesRangeRespVo>> list(TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo) {
                doBack();
                PageResult<TpmCostTypeCategoriesRangeRespVo> build = PageResult.<TpmCostTypeCategoriesRangeRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmCostTypeCategoriesRangeRespVo> query(TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo) {
                return doBack();
            }
        };
    }
}
