package com.biz.crm.tpm.feebudget.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDetailsRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDetailsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.feebudget.TpmFeeBudgetDetailsFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;

/**
 * 费用预算明细 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-16 10:42:32
 */
@Slf4j
@Component
public class TpmFeeBudgetDetailsFeignImpl extends BaseAbstract implements FallbackFactory<TpmFeeBudgetDetailsFeign> {

    @Override
    public TpmFeeBudgetDetailsFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmFeeBudgetDetailsFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmFeeBudgetDetailsRespVo>> list(TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo) {
                doBack();
                PageResult<TpmFeeBudgetDetailsRespVo> build = PageResult.<TpmFeeBudgetDetailsRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmFeeBudgetDetailsRespVo> query(TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo) {
                return doBack();
            }
        };
    }
}
