package com.biz.crm.tpm.fiscalyear;

import com.biz.crm.tpm.fiscalyear.impl.TpmFiscalYearSettingFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.fiscalyear.resp.TpmFiscalYearSettingRespVo;
import com.biz.crm.nebular.tpm.fiscalyear.req.TpmFiscalYearSettingReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;

/**
 * 财年设置 财年设置表feign接口
 *
 * @author huang.long
 * @date 2020-09-08 11:19:03
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmFiscalYearSettingFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmFiscalYearSettingFeignImpl.class)
public interface TpmFiscalYearSettingFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmfiscalyearsetting/list")
    Result<PageResult<TpmFiscalYearSettingRespVo>> list(@RequestBody TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmfiscalyearsetting/query")
    Result<TpmFiscalYearSettingRespVo> query(@RequestBody TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmfiscalyearsetting/save")
    Result save(@RequestBody TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmfiscalyearsetting/update")
    Result update(@RequestBody TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmfiscalyearsetting/delete")
    Result delete(@RequestBody TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmfiscalyearsetting/enable")
    Result enable(@RequestBody TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmfiscalyearsetting/disable")
    Result disable(@RequestBody TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);
}
