package com.biz.crm.tpm.liqueuract;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.tpm.liqueuract.impl.TpmLiqueurActCallBackFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author maoshen
 * @date 2021/3/23.
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "TpmLiqueurActCallBackFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmLiqueurActCallBackFeignImpl.class)
public interface TpmLiqueurActCallBackFeign extends CallbackFeign {

    /**
     * 回调方法
     * @param activitiCallBackVo
     * @return
     */
    @Override
    @PostMapping("/tpmLiqueurActController/activityCallBack")
    Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo);
}
