package com.biz.crm.upload.excel.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.upload.excel.req.ExcelExportReqVo;
import com.biz.crm.nebular.upload.excel.resp.ExcelExportRespVo;
import com.biz.crm.upload.excel.ExcelExportFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.ArrayList;

/**
 * 导出文件feign接口熔断类
 *
 * @author lf
 * @date 2020-12-06 17:11:15
 */
@Slf4j
@Component
public class ExcelExportFeignImpl extends BaseAbstract implements FallbackFactory<ExcelExportFeign> {

    @Override
    public ExcelExportFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new ExcelExportFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<ExcelExportRespVo>> list(ExcelExportReqVo excelExportReqVo) {
                doBack();
                PageResult<ExcelExportRespVo> build = PageResult.<ExcelExportRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<ExcelExportRespVo> query(ExcelExportReqVo excelExportReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(ExcelExportReqVo excelExportReqVo) {
                return doBack();
            }

            @PostMapping("/excelExportController/saveExcelFileBackId")
            @Override
            public Result<ExcelExportReqVo> saveExcelFileBackId(ExcelExportReqVo excelExportReqVo) {
                return doBack();
            }

            @PostMapping("/excelExportController/updateExcelFileById")
            @Override
            public Result updateExcelFileById(ExcelExportReqVo excelExportReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(ExcelExportReqVo excelExportReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(ExcelExportReqVo excelExportReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(ExcelExportReqVo excelExportReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(ExcelExportReqVo excelExportReqVo) {
                return doBack();
            }
        };
    }
}
