/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

@SpringBootApplication
public class GatewayServiceApplication {
    private static final Logger log = LoggerFactory.getLogger(GatewayServiceApplication.class);

    public static void main(String[] args) throws UnknownHostException {
        ConfigurableApplicationContext application = SpringApplication.run(GatewayServiceApplication.class, (String[])args);
        ConfigurableEnvironment env = application.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n----------------------------------------------------------\n\tApplication crm-gateway is running! Access URLs:\n\t\u672c\u5730\u8bbf\u95ee\u5730\u5740: \t\thttp://localhost:" + port + path + "/\n\tswagger\u5730\u5740: \t\thttp://localhost:" + port + path + "/doc.html\n----------------------------------------------------------");
    }
}

