package com.biz.crm;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm
 * @Description: TODO
 * @date 2021/6/10 上午12:09
 */
@SpringBootApplication
@Slf4j
public class GatewayServiceApplication {
    public static void main(String[] args) throws UnknownHostException {
        ConfigurableApplicationContext application = SpringApplication.run(GatewayServiceApplication.class, args);
        Environment env = application.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n----------------------------------------------------------\n\t" +
                "Application crm-gateway is running! Access URLs:\n\t" +
                "本地访问地址: \t\thttp://localhost:" + port + path + "/\n\t" +
//            "外部访问地址: \thttp://" + ip + ":" + port + path + "/\n\t" +
                "swagger地址: \t\thttp://localhost:" + port + path + "/doc.html\n" +
                "----------------------------------------------------------");
    }
}
