/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduleUtils.class);
    public static final String JOB_PARAM_KEY = "scheduleJob";

    public static TriggerKey getTriggerKey(String jobName, String jobGroup) {
        return TriggerKey.triggerKey((String)jobName, (String)jobGroup);
    }

    public static CronTrigger getCronTrigger(Scheduler scheduler, String jobName, String jobGroup) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            return (CronTrigger)scheduler.getTrigger(triggerKey);
        }
        catch (SchedulerException e) {
            LOG.error("\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1CronTrigger\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static void createScheduleJob(Scheduler scheduler, Class<? extends Job> jobClass, String jobName, String jobGroup, String cronExpression) throws Exception {
        ScheduleUtils.createScheduleJob(scheduler, jobName, jobGroup, cronExpression, null, jobClass);
    }

    public static void createScheduleJob(Scheduler scheduler, String jobName, String jobGroup, String cronExpression, Object param, Class<? extends Job> jobClass) throws Exception {
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroup).storeDurably().build();
        jobDetail.getJobDataMap().put(JOB_PARAM_KEY, param);
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        scheduler.scheduleJob(jobDetail, (Trigger)trigger);
    }

    public static void updateScheduleJob(Scheduler scheduler, String jobName, String jobGroup, String cronExpression) throws SchedulerException {
        TriggerKey triggerKey = ScheduleUtils.getTriggerKey(jobName, jobGroup);
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
        CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
        trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
    }

    public static JobKey getJobKey(String jobName, String jobGroup) {
        return JobKey.jobKey((String)jobName, (String)jobGroup);
    }

    public static void deleteScheduleJob(Scheduler scheduler, String jobName, String jobGroup) throws SchedulerException {
        scheduler.deleteJob(ScheduleUtils.getJobKey(jobName, jobGroup));
    }

    public static void resumeJob(Scheduler scheduler, String jobName, String jobGroup) throws SchedulerException {
        JobKey jobKey = ScheduleUtils.getJobKey(jobName, jobGroup);
        scheduler.resumeJob(jobKey);
    }

    public static void pauseJob(Scheduler scheduler, String jobName, String jobGroup) throws SchedulerException {
        JobKey jobKey = ScheduleUtils.getJobKey(jobName, jobGroup);
        scheduler.pauseJob(jobKey);
    }

    public static void runOnce(Scheduler scheduler, String jobName, String jobGroup) throws SchedulerException {
        JobKey jobKey = ScheduleUtils.getJobKey(jobName, jobGroup);
        scheduler.triggerJob(jobKey);
    }
}

