package com.biz.crm.confadmin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.confadmin.model
 * @ClassName KmsInterfaceParamOptionEntity
 * @Author Gavin
 * @Date 2021/5/6 下午3:53
 * @Description kms抓单接口下拉参数
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_interface_param_option")
@CrmTable(name = "kms_interface_param_option", tableNote = "kms抓单接口下拉参数")
public class KmsInterfaceParamOptionEntity extends CrmExtTenEntity<KmsGrabRuleEntity> {
    private static final long serialVersionUID = -5410994673825760641L;

    /**
     * 抓单接口参数主表id
     */
    @CrmColumn(name = "field_id", length = 64, note = "抓单接口参数主表id")
    private String fieldId;

    /**
     * 列表选项名称
     */
    @CrmColumn(name = "option_name", length = 64, note = "列表选项名称")
    private String optionName;

    /**
     * 列表选项值
     */
    @CrmColumn(name = "option_value", length = 64, note = "列表选项值")
    private String optionValue;

    /**
     * 展示顺序
     */
    @CrmColumn(name = "sort_index", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "展示顺序")
    private Integer sortIndex;
}