package com.biz.crm.finance.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.finance.model
 * @ClassName KmsAuditTemplateEntity
 * @Author Gavin
 * @Date 2021/5/25 下午2:36
 * @Description 稽核模板
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_audit_template")
@CrmTable(name = "kms_audit_template", tableNote = "稽核模板")
public class KmsAuditTemplateEntity extends CrmExtTenEntity<KmsAuditTemplateEntity> {
    private static final long serialVersionUID = 7193451998703751066L;

    /**
     * 稽核模版名称
     */
    @CrmColumn(name = "template_name", length = 255, note = "稽核模版名称")
    private String templateName;

    /**
     * 稽核单据类型
     */
    @CrmColumn(name = "order_type_array", length = 255, note = "稽核单据类型")
    private String orderTypeArray;

    /**
     * 稽核条件
     */
    @CrmColumn(name = "condition_array", length = 255, note = "稽核条件")
    private String conditionArray;

}