package com.biz.crm.grabrule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 抓单规则配置表实体类
 *
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_grab_rule")
@CrmTable(name = "kms_grab_rule", tableNote = "抓单规则配置表",indexes = {
        @Index(name = "kgr_bs_direct_system_code_index", columnList = "bs_direct_system_code")
})
public class KmsGrabRuleEntity extends CrmExtTenEntity<KmsGrabRuleEntity> {


    private static final long serialVersionUID = 6202265835000591437L;

    /**
     * 直营体系Id
     */
    @CrmColumn(name = "bs_direct_system_id", length = 64, note = "直营体系Id")
    private String bsDirectSystemId;

    /**
     * 直营体系编码
     */
    @CrmColumn(name = "bs_direct_system_code", length = 64, note = "直营体系编码")
    private String bsDirectSystemCode;


    /**
     * 直营体系名称
     */
    @CrmColumn(name = "bs_direct_system_name", length = 32, note = "直营体系名称")
    private String bsDirectSystemName;

    /**
     * 单据类型ID
     */
    @CrmColumn(name = "order_type_id", length = 64, note = "单据类型ID")
    private String orderTypeId;

    /**
     * 单据类型编码
     */
    @CrmColumn(name = "order_type", length = 64, note = "单据类型编码")
    private String orderType;

    /**
     * 单据下载方式
     */
    @CrmColumn(name = "order_download_way", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "单据下载方式")
    private Integer orderDownloadWay;

    /**
     * 原始文件格式
     */
    @CrmColumn(name = "file_classify", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "原始文件格式")
    private Integer fileClassify;

    /**
     * 文件下载方式
     */
    @CrmColumn(name = "file_download_way", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "文件下载方式")
    private Integer fileDownloadWay;

    /**
     * 抓单规则名称
     */
    @CrmColumn(name = "rule_name", length = 64, note = "抓单规则名称")
    private String ruleName;


    /**
     * 登录账号ID
     */
    @CrmColumn(name = "account_id", length = 64, note = "登录账号ID")
    private String accountId;


    /**
     * 作用门店是否选择全部标识(Y/N)
     */
    @CrmColumn(name = "is_all_store", length = 10, note = "作用门店是否选择全部标识(Y/N)")
    private String isAllStore;

    /**
     * 开始时间
     */
    @CrmColumn(name = "start_time", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "开始时间")
    private Integer startTime;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_time", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "结束时间")
    private Integer endTime;

    /**
     * 时间间隔
     */
    @CrmColumn(name = "interval_time", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "时间间隔")
    private Integer intervalTime;

    /**
     * 定时任务ID
     */
    @CrmColumn(name = "task_id", length = 64, note = "定时任务ID")
    private String taskId;
}
