package com.biz.crm.orderform.model;

import javax.persistence.Index;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 商超订货单表
 *
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_order_form")
@CrmTable(name = "kms_order_form", tableNote = "商超订货单表",indexes = {
        @Index(name = "kof_tenantry_id_index",columnList = "tenantry_id"),
        @Index(name = "kof_order_number_index", columnList = "order_number"),
        @Index(name = "kof_raw_data_id_index",columnList = "raw_data_id"),
        @Index(name = "kof_version_number_index",columnList = "version_number"),
        @Index(name = "kof_ka_order_number_index", columnList = "ka_order_number"),
        @Index(name = "kof_order_date_index", columnList = "order_date")
})
public class KmsOrderFormEntity extends CrmExtTenEntity<KmsOrderFormEntity> {
    private static final long serialVersionUID = -751523404850877595L;

    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    /**
     * 直营体系Id
     */
    @CrmColumn(name = "bs_direct_system_id", length = 64, note = "直营体系Id")
    private String bsDirectSystemId;

    @CrmColumn(name = "raw_data_id", length = 64, note = "原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @CrmColumn(name = "order_number", length = 64, note = "抓单生成的订单编号")
    private String orderNumber;

    @CrmColumn(name = "version_number", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "订单版本号")
    private Integer versionNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超订单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "order_status", length = 64, note = "单据当前状态")
    private String orderStatus;

    @CrmColumn(name = "order_status_msg", length = 512, note = "单据当前状态信息")
    private String orderStatusMsg;

    @CrmColumn(name = "invoices_source", length = 64, note = "单据来源")
    private String invoicesSource;

    @CrmColumn(name = "ka_code", length = 64, note = "商超编码")
    private String kaCode;

    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    @CrmColumn(name = "order_date", length = 64, note = "订单日期")
    private String orderDate;

    @CrmColumn(name = "delivery_date", length = 64, note = "交货日期")
    private String deliveryDate;

    @CrmColumn(name = "run_mode", length = 64, note = "经营方式")
    private String runMode;

    @CrmColumn(name = "final_order_amount", length = 64, note = "订货单总金额（含税）")
    private String finalOrderAmount;

    @CrmColumn(name = "final_order_amount_not", length = 64, note = "订货单总金额（不含税）")
    private String finalOrderAmountNot;

    @CrmColumn(name = "ka_store_code", length = 64, note = "商超门店/大仓编号")
    private String kaStoreCode;

    @CrmColumn(name = "ka_store_name", length = 255, note = "商超门店/大仓名称")
    private String kaStoreName;

    @CrmColumn(name = "store_code", length = 64, note = "企业门店/大仓编号")
    private String storeCode;

    @CrmColumn(name = "store_name", length = 255, note = "企业门店/大仓名称")
    private String storeName;

    /**
     * 关联ID(企业门店与商超门店表ID)
     */
    @CrmColumn(name = "store_related_id", length = 64, note = "关联ID(企业门店与商超门店表ID)")
    private String storeRelatedId;

    @CrmColumn(name = "delivery_address", length = 255, note = "送货地址")
    private String deliveryAddress;

    @CrmColumn(name = "delivery_contact", length = 64, note = "送货联系人")
    private String deliveryContact;

    @CrmColumn(name = "delivery_contact_phone", length = 64, note = "送货联系人电话")
    private String deliveryContactPhone;

    @CrmColumn(name = "business_area_leader", length = 64, note = "业务区域负责人")
    private String businessAreaLeader;

    @CrmColumn(name = "business_area", length = 64, note = "业务区域")
    private String businessArea;

    @CrmColumn(name = "area_code", length = 64, note = "区域编码")
    private String areaCode;

    @CrmColumn(name = "area_name", length = 255, note = "区域名称")
    private String areaName;

    @CrmColumn(name = "order_approval_number", length = 64, note = "订单审批单号")
    private String orderApprovalNumber;

    @CrmColumn(name = "sold_to_party_name", length = 255, note = "售达方名称")
    private String soldToPartyName;

    @CrmColumn(name = "sold_to_party_code", length = 64, note = "售达方编码")
    private String soldToPartyCode;

    @CrmColumn(name = "supplier_name", length = 255, note = "供应商名称")
    private String supplierName;

    @CrmColumn(name = "supplier_code", length = 64, note = "供应商编码")
    private String supplierCode;

    @CrmColumn(name = "customer_org_code", length = 64, note = "客户组织编码")
    private String customerOrgCode;

    @CrmColumn(name = "customer_org_type", length = 64, note = "客户组织类型")
    private String customerOrgType;

    @CrmColumn(name = "channel", length = 64, note = "渠道")
    private String channel;

    @CrmColumn(name = "max_unit_sum", length = 64, note = "SKU最大单位数量汇总")
    private String maxUnitSum;

    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @CrmColumn(name = "is_expedited", length = 64, note = "是否加急订单")
    private String isExpedited;

    @CrmColumn(name = "user_name", length = 64, note = "登录账号")
    private String userName;

    @CrmColumn(name = "sap_number", length = 64, note = "SAP订单号")
    private String sapNumber;

    @CrmColumn(name = "is_trans", length = 64, note = "是否能再次转换标示yes/no")
    private String isTrans;
}
