package com.biz.crm.rawdata.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.rawdata.entity
 * @ClassName KmsSaleDataFormDetailDwEntity
 * @Author Gavin
 * @Date 2021/8/23 下午2:38
 * @Description 商超销售原始单据
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_sale_data_form_detail_dw")
@CrmTable(name = "kms_sale_data_form_detail_dw", tableNote = "库存商超原始单据")
public class KmsSaleDataFormDetailDwEntity extends CrmExtTenEntity<KmsSaleDataFormDetailDwEntity> {
    private static final long serialVersionUID = 2724484535006088752L;

    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    @CrmColumn(name = "raw_data_id", length = 64, note = "原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @CrmColumn(name = "order_number", length = 64, note = "企业销售数据编号")
    private String orderNumber;

    @CrmColumn(name = "version_number", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "版本号")
    private Integer versionNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超单据编号")
    private String kaOrderNumber;

    @CrmColumn(name = "invoices_source", length = 64, note = "单据来源")
    private String invoicesSource;

    @CrmColumn(name = "ka_code", length = 64, note = "商超编码")
    private String kaCode;

    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    @CrmColumn(name = "sales_date", length = 64, note = "销售日期")
    private String salesDate;

    @CrmColumn(name = "ka_store_code", length = 64, note = "商超门店/大仓编号")
    private String kaStoreCode;

    @CrmColumn(name = "ka_store_name", length = 255, note = "商超门店/大仓名称")
    private String kaStoreName;

    @CrmColumn(name = "store_code", length = 64, note = "企业门店/大仓编号")
    private String storeCode;

    @CrmColumn(name = "store_name", length = 255, note = "企业门店/大仓名称")
    private String storeName;

    @CrmColumn(name = "goods_code", length = 64, note = "企业产品编号")
    private String goodsCode;

    @CrmColumn(name = "goods_name", length = 255, note = "企业产品名称")
    private String goodsName;

    @CrmColumn(name = "ka_goods_code", length = 64, note = "商超产品编号")
    private String kaGoodsCode;

    @CrmColumn(name = "ka_goods_name", length = 255, note = "商超产品名称")
    private String kaGoodsName;

    @CrmColumn(name = "goods_bar_code", length = 64, note = "产品国际条码")
    private String goodsBarCode;

    @CrmColumn(name = "specification", length = 64, note = "产品规格")
    private String specification;

    @CrmColumn(name = "sales_cost", length = 64, note = "销售成本")
    private String salesCost;

    @CrmColumn(name = "sales_amount", length = 64, note = "销售金额")
    private String salesAmount;

    @CrmColumn(name = "run_mode", length = 64, note = "经营方式")
    private String runMode;

    @CrmColumn(name = "trans_status", length = 4, note = "字段转换标识：0未转换,-1转换失败，1已转换", defaultValue = "0")
    private String transStatus;

    @CrmColumn(name = "area_code", length = 64, note = "门店所属大区编号")
    private String areaCode;

    @CrmColumn(name = "area_name", length = 255, note = "门店所属大区名称")
    private String areaName;

    @CrmColumn(name = "competitive_brands", length = 64, note = "竞品品牌")
    private String competitiveBrands;

    @CrmColumn(name = "cur_unit_level", length = 64, note = "当前单位层级")
    private String curUnitLevel;

    @CrmColumn(name = "cur_unit", length = 64, note = "当前单位")
    private String curUnit;

    @CrmColumn(name = "cur_unit_sales_quantity", length = 64, note = "当前单位销售数量")
    private String curUnitSalesQuantity;

    @CrmColumn(name = "min_unit_level", length = 64, note = "最小单位层级")
    private String minUnitLevel;

    @CrmColumn(name = "min_unit", length = 64, note = "最小单位")
    private String minUnit;

    @CrmColumn(name = "min_unit_sales_quantity", length = 64, note = "最小单位销售数量")
    private String minUnitSalesQuantity;

    @CrmColumn(name = "max_unit_level", length = 64, note = "最大单位层级")
    private String maxUnitLevel;

    @CrmColumn(name = "max_unit", length = 64, note = "最大单位")
    private String maxUnit;

    @CrmColumn(name = "max_unit_sales_quantity", length = 64, note = "最大单位销售数量")
    private String maxUnitSalesQuantity;

    @CrmColumn(name = "business_area", length = 64, note = "业务区域")
    private String businessArea;

    @CrmColumn(name = "user_name", length = 64, note = "登录账号")
    private String userName;
}