package com.biz.crm.sap.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * @Project crm
 * @PackageName com.biz.crm.sap.model
 * @ClassName KmsSapInvoiceEntity
 * @Author Gavin
 * @Date 2021/6/1 下午2:35
 * @Description SAP 发票信息
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_sap_invoice")
@CrmTable(name = "kms_sap_invoice", tableNote = "SAP发票信息",indexes = {
        @Index(name = "ksi_vbeln_index", columnList = "vbeln"),
        @Index(name = "ksi_vgbel_index", columnList = "vgbel"),
        @Index(name = "ksi_posnr_index", columnList = "posnr")
})
public class KmsSapInvoiceEntity extends CrmExtTenEntity<KmsSapInvoiceEntity> {

    private static final long serialVersionUID = -4157589251041679149L;
    @CrmColumn(name = "fkdat", length = 64, note = "出具发票日期")
    private String fkdat;

    @CrmColumn(name = "erzet", length = 64, note = "创建时间")
    private String erzet;

    @CrmColumn(name = "fkart", length = 64, note = "开票类型")
    private String fkart;

    @CrmColumn(name = "fkartvtext", length = 64, note = "开票类型中文描述")
    private String fkartvtext;

    @CrmColumn(name = "vbeln", length = 64, note = "发票号")
    private String vbeln;

    @CrmColumn(name = "posnr", length = 64, note = "行项目")
    private String posnr;

    @CrmColumn(name = "pstyv", length = 64, note = "行项目类别")
    private String pstyv;

    @CrmColumn(name = "vtext", length = 64, note = "行项目类别中文描述")
    private String vtext;

    @CrmColumn(name = "vgbel", length = 64, note = "交货单号")
    private String vgbel;

    @CrmColumn(name = "vgpos", length = 64, note = "交货单行项目")
    private String vgpos;

    @CrmColumn(name = "aubel", length = 64, note = "订单号")
    private String aubel;

    @CrmColumn(name = "aupos", length = 64, note = "订单号行项目")
    private String aupos;

    @CrmColumn(name = "bukrs", length = 64, note = "公司代码")
    private String bukrs;

    @CrmColumn(name = "org_code", length = 64, note = "企业组织编码")
    private String orgCode;

    @CrmColumn(name = "matnr", length = 64, note = "物料编码")
    private String matnr;

    @CrmColumn(name = "maktx", length = 64, note = "物料描述")
    private String maktx;

    @CrmColumn(name = "mtpos", length = 64, note = "物料类型")
    private String  mtpos;

    @CrmColumn(name = "fkimg", mysqlType = "decimal(16,4)", oracleType = "NUMBER(16,4)", note = "发票数量")
    private BigDecimal fkimg;

    @CrmColumn(name = "fkimgzp", mysqlType = "decimal(16,4)", oracleType = "NUMBER(16,4)", note = "发票数量赠品不显示")
    private BigDecimal fkimgzp;

    @CrmColumn(name = "vrkme", length = 64, note = "销售单位")
    private String vrkme;

    @CrmColumn(name = "vrkmename", length = 64, note = "销售单位中文描述")
    private String vrkmename;

    @CrmColumn(name = "fkimg1", mysqlType = "decimal(22,9)", oracleType = "NUMBER(22,9)", note = "价格单位发票数量")
    private BigDecimal fkimg1;

    @CrmColumn(name = "fkimgzp1", mysqlType = "decimal(22,9)", oracleType = "NUMBER(22,9)", note = "价格单位发票数量赠品不显示")
    private BigDecimal fkimgzp1;

    @CrmColumn(name = "kmein", length = 64, note = "价格单位")
    private String kmein;

    @CrmColumn(name = "kmeinname", length = 64, note = "价格单位中文描述")
    private String kmeinname;

    @CrmColumn(name = "netwr", mysqlType = "decimal(18,2)", oracleType = "NUMBER(18,2)", note = "发票净值")
    private BigDecimal netwr;

    @CrmColumn(name = "mwsbp", mysqlType = "decimal(16,2)", oracleType = "NUMBER(16,2)", note = "发票税额")
    private BigDecimal mwsbp;

    @CrmColumn(name = "kzwi1", mysqlType = "decimal(16,2)", oracleType = "NUMBER(16,2)", note = "含税总价")
    private BigDecimal kzwi1;

    @CrmColumn(name = "mwsi1", mysqlType = "decimal(18,2)", oracleType = "NUMBER(18,2)", note = "税率")
    private BigDecimal mwsi1;

    @CrmColumn(name = "kzwi4", mysqlType = "decimal(16,2)", oracleType = "NUMBER(16,2)", note = "返利")
    private BigDecimal kzwi4;

    @CrmColumn(name = "yk99", mysqlType = "decimal(32,2)", oracleType = "NUMBER(32,2)", note = "折扣")
    private BigDecimal yk99;

    @CrmColumn(name = "kunnr", length = 64, note = "送达方编码")
    private String kunnr;

    @CrmColumn(name = "kunnrname", length = 64, note = "送达方名称")
    private String kunnrname;

    @CrmColumn(name = "kunag", length = 64, note = "售达方编码")
    private String kunag;

    @CrmColumn(name = "kunagname", length = 64, note = "售达方名称")
    private String kunagname;

    @CrmColumn(name = "vrkmetype", length = 64, note = "物料单位分类")
    private String vrkmetype;

    @CrmColumn(name = "guige", length = 64, note = "物料规格")
    private String guige;

    @CrmColumn(name = "vtweg", length = 64, note = "分销渠道")
    private String vtweg;

    @CrmColumn(name = "vbakerdat", length = 64, note = "订单创建日期")
    private String vbakerdat;

    @CrmColumn(name = "lifnr", length = 64, note = "配送商编码")
    private String lifnr;

    @CrmColumn(name = "name3", length = 64, note = "配送商名称")
    private String name3;

    @CrmColumn(name = "bstkd", length = 64, note = "商超订单编号")
    private String bstkd;

    @CrmColumn(name = "danjia", mysqlType = "decimal(32,2)", oracleType = "NUMBER(32,2)", note = "产品含税单价")
    private BigDecimal danjia;

    @CrmColumn(name = "yk04", mysqlType = "decimal(32,2)", oracleType = "NUMBER(32,2)", note = "物料数量价格折扣 (PR)")
    private BigDecimal yk04;

    @CrmColumn(name = "yk11", mysqlType = "decimal(32,2)", oracleType = "NUMBER(32,2)", note = "即时返点%产品组折扣(PR)")
    private BigDecimal yk11;

    @CrmColumn(name = "zst2", mysqlType = "decimal(32,2)", oracleType = "NUMBER(32,2)", note = "赠品分摊折扣")
    private BigDecimal zst2;

    @CrmColumn(name = "pernr", length = 64, note = "业务员编码")
    private String pernr;

    @CrmColumn(name = "name4", length = 64, note = "业务员描述")
    private String name4;
}