package com.biz.crm.supermarket.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 企业门店与商超门店关系实体类
 *
 * @author Gavin
 * @date 2021-04-15 11:31:07
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_tenantry_direct_store")
@CrmTable(name = "kms_tenantry_direct_store", tableNote = "企业门店与商超门店关系", indexes = {
        @Index(name = "ktds_bs_direct_system_id_index", columnList = "bs_direct_system_id"),
        @Index(name = "ktds_bs_direct_system_code_index", columnList = "bs_direct_system_code"),
        @Index(name = "ktds_store_id_index", columnList = "store_id"),
})
public class KmsTenantryDirectStoreEntity extends CrmExtTenEntity<KmsTenantryDirectStoreEntity> {


    private static final long serialVersionUID = -1038755808810035724L;

    /**
     * 直营体系Id
     */
    @CrmColumn(name = "bs_direct_system_id", length = 64, note = "直营体系Id")
    private String bsDirectSystemId;

    /**
     * 直营体系编码
     */
    @CrmColumn(name = "bs_direct_system_code", length = 64, note = "直营体系编码")
    private String bsDirectSystemCode;


    /**
     * 直营体系名称
     */
    @CrmColumn(name = "bs_direct_system_name", length = 256, note = "直营体系名称")
    private String bsDirectSystemName;


    /**
     * 企业门店编码
     */
    @CrmColumn(name = "terminal_code", length = 64, note = "企业门店编码")
    private String terminalCode;


    /**
     * 企业门店名称
     */
    @CrmColumn(name = "terminal_name", length = 512, note = "企业门店名称")
    private String terminalName;


    /**
     * 商超门店Id
     */
    @CrmColumn(name = "store_id", length = 64, note = "商超门店id")
    private String storeId;

    /**
     * 商超门店编码
     */
    @CrmColumn(name = "store_code", length = 64, note = "商超门店编码")
    private String storeCode;


    /**
     * 商超门店名称
     */
    @CrmColumn(name = "store_name", length = 512, note = "商超门店名称")
    private String storeName;

    /**
     * 对账匹配阈值（天数）
     * 匹配门店时对时间进行处理
     */
    @CrmColumn(name = "time_of_day", mysqlType = "int(11)", oracleType = "NUMBER(10,0)", note = "对账匹配阈值（天数）")
    private Integer timeOfDay;
}
