package com.biz.crm.confadmin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.confadmin.model
 * @ClassName KmsDirectOrderTypeEntity
 * @Author Gavin
 * @Date 2021/5/6 上午10:40
 * @Description 商超支持抓取单据类型
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_direct_order_type")
@CrmTable(name = "kms_direct_order_type", tableNote = "商超支持抓取单据类型信息")
public class KmsDirectOrderTypeEntity extends CrmExtTenEntity<KmsGrabRuleEntity> {
    private static final long serialVersionUID = -2276776986630276888L;

    /**
     * 商超名称
     */
    @CrmColumn(name = "direct_id", length = 64, note = "商超ID")
    private String directId;


    /**
     * 单据类型编码
     */
    @CrmColumn(name = "order_type", length = 32, note = "单据类型编码")
    private String orderType;

    /**
     * 单据类型名称
     */
    @CrmColumn(name = "order_type_name", length = 64, note = "单据类型名称")
    private String orderTypeName;
}