package com.biz.crm.confadmin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.confadmin.model
 * @ClassName KmsDirectStoreAreaEntity
 * @Author Gavin
 * @Date 2021/5/6 上午10:59
 * @Description 商超门店区域管理
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_direct_store_area")
@CrmTable(name = "kms_direct_store_area", tableNote = "商超门店区域管理")
public class KmsDirectStoreAreaEntity extends CrmExtTenEntity<KmsGrabRuleEntity> {
    private static final long serialVersionUID = 5117245668335646591L;

    @CrmColumn(name = "direct_id", length = 64, note = "商超ID")
    private String directId;

    @CrmColumn(name = "ds_area_code", length = 64, note = "商超门店区域编码")
    private String dsAreaCode;

    @CrmColumn(name = "ds_area_name", length = 64, note = "商超门店区域名称")
    private String dsAreaName;
}