package com.biz.crm.confadmin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.confadmin.model
 * @ClassName KmsDirectSystemEntity
 * @Author Gavin
 * @Date 2021/5/6 上午10:34
 * @Description 商超管理 Kms_direct_system
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_direct_system")
@CrmTable(name = "kms_direct_system", tableNote = "商超信息")
public class KmsDirectSystemEntity extends CrmExtTenEntity<KmsGrabRuleEntity> {
    private static final long serialVersionUID = 2618189026092955255L;

    /**
     * 商超名称
     */
    @CrmColumn(name = "direct_name", length = 512, note = "商超名称")
    private String directName;


    /**
     * 商超地址
     */
    @CrmColumn(name = "vendor_system_url", length = 512, note = "商超url地址")
    private String vendorSystemUrl;

}