package com.biz.crm.finance.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Project crm
 * @PackageName com.biz.crm.finance.model
 * @ClassName KmsAcceptanceMatchRelationEntity
 * @Author Gavin
 * @Date 2021/6/18 下午8:18
 * @Description 验收匹配模版关系表
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_acceptance_match_relation")
@CrmTable(name = "kms_acceptance_match_relation", tableNote = "稽核验收匹配关系表",indexes = {
        @Index(name = "kacmr_audit_id_index", columnList = "audit_id"),
        @Index(name = "kacmr_audit_number_index", columnList = "audit_number"),
        @Index(name = "kacmr_relation_id_index", columnList = "relation_id"),
        @Index(name = "kacmr_audit_template_id_index", columnList = "audit_template_id"),
})
public class KmsAcceptanceMatchRelationEntity  extends CrmExtTenEntity<KmsAcceptanceMatchRelationEntity> {
    private static final long serialVersionUID = 7579530669430521260L;

    @CrmColumn(name = "audit_id", length = 128, note = "稽核Id")
    private String auditId;

    @CrmColumn(name = "audit_number", length = 128, note = "稽核单号")
    private String auditNumber;

    @CrmColumn(name = "relation_id", length = 128, note = "关系表ID")
    private String relationId;

    @CrmColumn(name = "header_id", length = 128, note = "头表ID")
    private String headerId;

    /**
     * 匹配模版ID
     */
    @CrmColumn(name = "audit_template_id", length = 64, note = "稽核模版ID")
    private String auditTemplateId;
}