package com.biz.crm.kaproduct.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 企业产品与商超产品单位转换关系表实体类
 *
 * @author Gavin
 * @date 2021-04-15 14:28:52
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_product_unit")
@CrmTable(name = "kms_product_unit", tableNote = "企业产品与商超产品单位转换关系表",indexes = {
        @Index(name = "kpu_tenantry_direct_product_id_index", columnList = "tenantry_direct_product_id")
})
public class KmsProductUnitEntity extends CrmExtTenEntity<KmsProductUnitEntity> {


    private static final long serialVersionUID = 5486225054730432400L;
    /**
     * 企业产品与商超产品关系ID
     */
    @CrmColumn(name = "tenantry_direct_product_id", length = 64, note = "企业产品与商超产品关系ID")
    private String tenantryDirectProductId;


    /**
     * 单据类型
     */
    @CrmColumn(name = "order_type", length = 512, note = "单据类型")
    private String orderType;


    /**
     * 企业产品单位编码
     */
    @CrmColumn(name = "unit_code", length = 64, note = "企业产品单位编码")
    private String unitCode;


    /**
     * 企业产品单位名称
     */
    @CrmColumn(name = "unit_name", length = 64, note = "企业产品单位名称")
    private String unitName;

    /**
     * 企业单位数量
     */
    @CrmColumn(name = "numerator", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "企业单位数量")
    private BigDecimal numerator;


    /**
     * numerator * 企业单位 = ratio * 商超单位
     * 商超单位数量
     */
    @CrmColumn(name = "ratio", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "商超单位数量")
    private BigDecimal ratio;

    /**
     * 商超产品单位名称
     */
    @CrmColumn(name = "ka_unit_code", length = 64, note = "商超产品单位名称")
    private String kaUnitCode;


}
