package com.biz.crm.kaproduct.model;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 企业产品与商超产品关系实体类
 *
 * @author Gavin
 * @date 2021-04-15 14:28:52
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_tenantry_direct_product")
@CrmTable(name = "kms_tenantry_direct_product", tableNote = "企业产品与商超产品关系", indexes = {
        @Index(name = "ktdp_bs_direct_system_code_index", columnList = "bs_direct_system_code")
})
public class KmsTenantryDirectProductEntity extends CrmExtTenEntity<KmsTenantryDirectProductEntity> {


    private static final long serialVersionUID = 5954224906636403217L;

    /**
     * 商超Id
     */
    @CrmColumn(name = "direct_id", length = 64, note = "商超ID")
    private String directId;

    /**
     * 直营体系Id
     */
    @CrmColumn(name = "bs_direct_system_id", length = 64, note = "直营体系Id")
    private String bsDirectSystemId;

    /**
     * 直营体系编码
     */
    @CrmColumn(name = "bs_direct_system_code", length = 64, note = "直营体系编码")
    private String bsDirectSystemCode;


    /**
     * 直营体系名称
     */
    @CrmColumn(name = "bs_direct_system_name", length = 256, note = "直营体系名称")
    private String bsDirectSystemName;


    /**
     * 售达方编码
     */
    @CrmColumn(name = "sell_party_code", length = 64, note = "售达方编码")
    private String sellPartyCode;


    /**
     * 售达方名称
     */
    @CrmColumn(name = "sell_party_name", length = 512, note = "售达方名称")
    private String sellPartyName;


    /**
     * 企业产品编码
     */
    @CrmColumn(name = "product_code", length = 64, note = "企业产品编码")
    private String productCode;


    /**
     * 企业产品名称
     */
    @CrmColumn(name = "product_name", length = 512, note = "企业产品名称")
    private String productName;


    /**
     * 商超产品编码
     */
    @CrmColumn(name = "ka_product_code", length = 64, note = "商超产品编码")
    private String kaProductCode;


    /**
     * 是否默认产品(Y/N)
     */
    @CrmColumn(name = "is_default", length = 10, note = "是否默认产品(Y/N)")
    private String isDefault;


    /**
     * 是否直营产品（Y/N）
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @CrmColumn(name = "is_direct", length = 10, note = "是否直营产品（Y/N）")
    private String isDirect;

    /**
     * 使用时间星期数
     */
    @CrmColumn(name = "time_of_week", mysqlType = "int(11)", oracleType = "NUMBER(10,0)", note = "使用时间星期数")
    private Integer timeOfWeek;
}
