package com.biz.crm.rawdata.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.rawdata.model
 * @ClassName KmsAcceptanceGoodsDetailDwEntity
 * @Author Gavin
 * @Date 2021/5/11 下午3:05
 * @Description 验收单原始单据详情
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_acceptance_goods_detail_dw")
@CrmTable(name = "kms_acceptance_goods_detail_dw", tableNote = "验收单原始单据详情")
public class KmsAcceptanceGoodsDetailDwEntity extends CrmExtTenEntity<KmsAcceptanceGoodsDetailDwEntity> {
    private static final long serialVersionUID = -607134271354305238L;

    /**
     * 租户ID
     */
    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    @CrmColumn(name = "raw_data_id", length = 64, note = "原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @CrmColumn(name = "order_number", length = 64, note = "抓单生成的验收单编号")
    private String orderNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超验收单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "goods_code", length = 64, note = "企业产品编号")
    private String goodsCode;

    @CrmColumn(name = "goods_name", length = 255, note = "企业产品名称")
    private String goodsName;

    @CrmColumn(name = "ka_goods_code", length = 64, note = "商超产品编号")
    private String kaGoodsCode;

    @CrmColumn(name = "ka_goods_name", length = 255, note = "商超产品名称")
    private String kaGoodsName;

    @CrmColumn(name = "goods_bar_code", length = 64, note = "产品国际条码")
    private String goodsBarCode;

    @CrmColumn(name = "specification", length = 64, note = "产品规格")
    private String specification;

    @CrmColumn(name = "cur_unit_acceptance_quantity", length = 255, note = "当前单位验收数量")
    private String curUnitAcceptanceQuantity;

    @CrmColumn(name = "cur_unit", length = 255, note = "当前单位")
    private String curUnit;

    @CrmColumn(name = "cur_unit_level", length = 255, note = "当前单位层级")
    private String curUnitLevel;

    @CrmColumn(name = "min_unit_acceptance_quantity", length = 255, note = "最小单位验收数量")
    private String minUnitAcceptanceQuantity;

    @CrmColumn(name = "min_unit", length = 255, note = "最小单位")
    private String minUnit;

    @CrmColumn(name = "min_unit_level", length = 255, note = "最小单位层级")
    private String minUnitLevel;

    @CrmColumn(name = "max_unit_acceptance_quantity", length = 255, note = "最大单位验收数量")
    private String maxUnitAcceptanceQuantity;

    @CrmColumn(name = "max_unit", length = 255, note = "最大单位")
    private String maxUnit;

    @CrmColumn(name = "max_unit_level", length = 255, note = "最大单位层级")
    private String maxUnitLevel;

    @CrmColumn(name = "order_quantity", length = 255, note = "订货数量")
    private String orderQuantity;

    @CrmColumn(name = "order_amount", length = 255, note = "订货金额小计（含税）")
    private String orderAmount;

    @CrmColumn(name = "acceptance_amount", length = 255, note = "验收金额小计（含税）")
    private String acceptanceAmount;

    @CrmColumn(name = "order_amount_not", length = 255, note = "订货金额小计（不含税）")
    private String orderAmountNot;

    @CrmColumn(name = "acceptance_amount_not", length = 255, note = "验收金额小计（不含税）")
    private String acceptanceAmountNot;

    @CrmColumn(name = "trans_status", length = 64, note = "字段转换标识：0未转换,-1转换失败，1已转换", defaultValue = "0")
    private String transStatus;

    @CrmColumn(name = "sold_to_party_name", length = 255, note = "售达方名称")
    private String soldToPartyName;

    @CrmColumn(name = "sold_to_party_code", length = 64, note = "售达方编码")
    private String soldToPartyCode;

    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    @CrmColumn(name = "item_index", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "行信息排序")
    private Integer itemIndex;
}