package com.biz.crm.rawdata.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Project crm
 * @PackageName com.biz.crm.rawdata.model
 * @ClassName KmsGrabResponseDataEntity
 * @Author Gavin
 * @Date 2021/5/7 上午10:29
 * @Description 抓取的原始数据信息python
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_grab_response_data")
@CrmTable(name = "kms_grab_response_data", tableNote = "抓取的原始数据信息")
public class KmsGrabResponseDataEntity extends BaseIdEntity implements Serializable {
    private static final long serialVersionUID = 6895688382823148035L;

    /**
     * 租户ID
     */
    @CrmColumn(name = "tenantry_id", length = 64, note = "租户ID")
    private String tenantryId;

    /**
     * 商超名称
     */
    @CrmColumn(name = "ka_name", length = 255, note = "商超名称")
    private String kaName;

    /**
     * 订单类型
     */
    @CrmColumn(name = "type", length = 64, note = "订单类型")
    private String type;

    /**
     * 请求参数
     */
    @CrmColumn(name = "request_param", mysqlType = "LONGTEXT",oracleType = "CLOB", note = "请求参数")
    private String requestParam;

    /**
     * 返回内容
     */
    @CrmColumn(name = "response_content", mysqlType = "LONGTEXT",oracleType = "CLOB", note = "返回内容")
    private String responseContent;

    /**
     * 数据添加方式
     */
    @CrmColumn(name = "invoices_source", length = 64, note = "数据添加方式")
    private String invoicesSource;

    /**
     * 处理状态
     */
    @CrmColumn(name = "processing_status", mysqlType = "int(11)", oracleType = "NUMBER(10,0)", note = "处理状态")
    private String processingStatus;

    /**
     * 删除标记
     */
    @CrmColumn(name = "is_delete", mysqlType = "int(11)", oracleType = "NUMBER(10,0)", note = "删除标记")
    private String isDelete;

    /**
     * 创建时间
     */
    @CrmColumn(name = "create_date", mysqlType = "DATETIME",oracleType = "DATE",note = "创建时间")
    private String createDate;

    /**
     * 创建人
     */
    @CrmColumn(name = "create_name", length = 64, note = "创建人")
    private String createName;

    /**
     * 更新时间
     */
    @CrmColumn(name = "update_date", mysqlType = "DATETIME",oracleType = "DATE",note = "更新时间")
    private String updateDate;

    /**
     * 更新人
     */
    @CrmColumn(name = "update_name", length = 64, note = "更新人")
    private String updateName;

    /**
     * 账号
     */
    @CrmColumn(name = "username", length = 64, note = "账号")
    private String username;
}
