package com.biz.crm.acceptanceform.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Project crm
 * @PackageName com.biz.crm.acceptanceform.model
 * @ClassName KmsAcceptanceStatusRecord
 * @Author Gavin
 * @Date 2021/5/11 下午4:04
 * @Description 验收单状态流转表
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_acceptance_status_record")
@CrmTable(name = "kms_acceptance_status_record", tableNote = "验收单状态流转表",indexes = {
        @Index(name = "kasr_order_number_index", columnList = "order_number"),
        @Index(name = "kasr_ka_order_number_index", columnList = "ka_order_number")
})
public class KmsAcceptanceStatusRecordEntity extends CrmExtTenEntity<KmsAcceptanceStatusRecordEntity> {
    private static final long serialVersionUID = -1540455369490917072L;
    @CrmColumn(name = "order_number", length = 64, note = "抓单生成的订单编号")
    private String orderNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超订单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "order_status", length = 64, note = "订单当前状态 枚举KmsEnum.AcceptanceStatus")
    private String orderStatus;

    @CrmColumn(name = "order_status_msg", length = 512, note = "单据当前状态信息")
    private String orderStatusMsg;
}