package com.biz.crm.orderform.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Project crm
 * @PackageName com.biz.crm.orderform.model
 * @ClassName KmsOrderStatusEntity
 * @Author Gavin
 * @Date 2021/4/28 下午3:26
 * @Description 商超订货单状态流转记录表
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_order_status_record")
@CrmTable(name = "kms_order_status_record", tableNote = "商超订货单状态流转记录表",indexes = {
        @Index(name = "kosr_order_number_index", columnList = "order_number"),
        @Index(name = "kosr_version_number_index",columnList = "version_number"),
        @Index(name = "kosr_ka_order_number_index", columnList = "ka_order_number")
})
public class KmsOrderStatusRecordEntity extends CrmExtTenEntity<KmsOrderFormEntity> {
    private static final long serialVersionUID = 5069625910918523564L;

    @CrmColumn(name = "order_number", length = 64, note = "抓单生成的订单编号")
    private String orderNumber;

    @CrmColumn(name = "version_number", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "订单版本号")
    private Integer versionNumber;

    @CrmColumn(name = "ka_order_number", length = 64, note = "商超订单编号")
    private String kaOrderNumber;

    @CrmColumn(name = "order_status", length = 64, note = "订单当前状态 枚举KmsEnum.OrderStatus")
    private String orderStatus;

    @CrmColumn(name = "order_status_msg", length = 512, note = "单据当前状态信息")
    private String orderStatusMsg;
}