package com.biz.crm.supermarket.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 客户组织与抓单商超（直营体系）关系表实体类
 *
 * @author Gavin
 * @date 2021-04-13 17:05:17
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_tenantry_direct_customer_org")
@CrmTable(name = "kms_tenantry_direct_customer_org", tableNote = "客户组织与抓单商超（直营体系）关系表")
public class KmsTenantryDirectCustomerOrgEntity extends CrmExtTenEntity<KmsTenantryDirectCustomerOrgEntity> {


    private static final long serialVersionUID = -6366150840360742420L;
    /**
     * 商超ID
     */
    @CrmColumn(name = "direct_id", length = 64, note = "商超ID")
    private String directId;


    /**
     * 直营体系编码
     */
    @CrmColumn(name = "bs_direct_system_code", length = 64, note = "直营体系编码")
    private String bsDirectSystemCode;


    /**
     * 直营体系名称
     */
    @CrmColumn(name = "bs_direct_system_name", length = 256, note = "直营体系名称")
    private String bsDirectSystemName;


    /**
     * 客户组织ID
     */
    @CrmColumn(name = "customer_org_id", length = 64, note = "客户组织ID")
    private String customerOrgId;


    /**
     * 客户组织编码
     */
    @CrmColumn(name = "customer_org_code", length = 64, note = "客户组织编码")
    private String customerOrgCode;


    /**
     * 客户组织名称
     */
    @CrmColumn(name = "customer_org_name", length = 256, note = "客户组织名称")
    private String customerOrgName;

    /**
     * 订单推送SAP时间计算阈值
     */
    @CrmColumn(name = "time_of_day", mysqlType = "int(11)", oracleType = "NUMBER(10,0)", note = "订单推送SAP时间计算阈值")
    private Integer timeOfDay;
}
