package com.biz.crm.confadmin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.confadmin.model
 * @ClassName KmsDirectStoreEntity
 * @Author Gavin
 * @Date 2021/5/6 上午11:04
 * @Description 商超门店管理
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_direct_store")
@CrmTable(name = "kms_direct_store", tableNote = "商超门店管理")
public class KmsDirectStoreEntity extends CrmExtTenEntity<KmsGrabRuleEntity> {
    private static final long serialVersionUID = 2118823464802352878L;

    @CrmColumn(name = "direct_id", length = 64, note = "商超ID")
    private String directId;

    @CrmColumn(name = "store_code", length = 64, note = "商超门店编码")
    private String storeCode;

    @CrmColumn(name = "store_name", length = 512, note = "商超门店名称")
    private String storeName;

    @CrmColumn(name = "area_id", length = 64, note = "商超门店区域ID")
    private String areaId;

    @CrmColumn(name = "store_address", length = 512, note = "门店地址")
    private String storeAddress;

    @CrmColumn(name = "phone", length = 512, note = "联系电话")
    private String phone;
}