package com.biz.crm.confadmin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.confadmin.model
 * @ClassName KmsInterfaceParamEntity
 * @Author Gavin
 * @Date 2021/5/6 下午3:36
 * @Description kms抓单接口参数
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_interface_param")
@CrmTable(name = "kms_interface_param", tableNote = "kms抓单接口参数")
public class KmsInterfaceParamEntity extends CrmExtTenEntity<KmsGrabRuleEntity> {
    private static final long serialVersionUID = -7445273804818047026L;

    /**
     * 商超ID
     */
    @CrmColumn(name = "direct_id", length = 64, note = "商超ID")
    private String directId;

    /**
     * 单据类型编码
     */
    @CrmColumn(name = "order_type", length = 32, note = "单据类型编码")
    private String orderType;

    /**
     * 属性
     */
    @CrmColumn(name = "field_en", length = 64, note = "参数属性名")
    private String fieldEn;

    /**
     * 参数文本
     */
    @CrmColumn(name = "field_cn", length = 64, note = "参数文本名")
    private String fieldCn;

    /**
     * 控件类型
     */
    @CrmColumn(name = "field_classify", length = 64, note = "控件类型")
    private String fieldClassify;

    /**
     * 参数类型
     */
    @CrmColumn(name = "param_classify", length = 64, note = "参数类型")
    private String paramClassify;

    /**
     * 提示文字
     */
    @CrmColumn(name = "prompt_text", length = 256, note = "提示文字")
    private String promptText;

    /**
     * 字段是否必填
     */
    @CrmColumn(name = "is_required", length = 32, note = "字段是否必填(YES/NO)")
    private String isRequired;

    /**
     * 是否显示（0：显示，1：不显示）
     */
    @CrmColumn(name = "is_show", length = 32, note = "是否显示（0：显示，1：不显示）")
    private String isShow;

    /**
     * 字段排序
     */
    @CrmColumn(name = "sort_index", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "字段排序")
    private Integer sortIndex;

    /**
     * 查询条件（0：不是筛选字段，1：是筛选字段）
     */
    @CrmColumn(name = "is_screen", length = 32, note = "查询条件（0：不是筛选字段，1：是筛选字段）")
    private String isScreen;
}