package com.biz.crm.finance.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * @Project crm
 * @PackageName com.biz.crm.finance.model
 * @ClassName KmsAuditTemplateDirectEntity
 * @Author Gavin
 * @Date 2021/5/25 下午3:22
 * @Description 稽核模板商超信息
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_audit_template_direct")
@CrmTable(name = "kms_audit_template_direct", tableNote = "稽核模板商超信息",indexes = {
        @Index(name = "katd_direct_id_index", columnList = "direct_id")
})
public class KmsAuditTemplateDirectEntity extends CrmExtTenEntity<KmsAuditTemplateEntity> {
    private static final long serialVersionUID = 109109728076407205L;

    /**
     * 稽核模版ID
     */
    @CrmColumn(name = "audit_template_id", length = 64, note = "稽核模版ID")
    private String auditTemplateId;

    /**
     * 商超ID
     */
    @CrmColumn(name = "direct_id", length = 64, note = "商超ID")
    private String directId;

    /**
     * 商超名称
     */
    @CrmColumn(name = "direct_name", length = 255, note = "商超名称")
    private String directName;

    /**
     * 容差规则（正/负/上下浮动）
     */
    @CrmColumn(name = "audit_rule", length = 255, note = "容差规则（正_Z/负_F/上下浮动_UD）")
    private String auditRule;

    /**
     * 价格允差
     */
    @CrmColumn(name = "difference_price", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "价格允差")
    private BigDecimal differencePrice;

}