package com.biz.crm.grabrule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Project crm
 * @PackageName com.biz.crm.grabrule.model
 * @ClassName KmsDataAuthEntity
 * @Author Gavin
 * @Date 2021/5/7 上午10:45
 * @Description 单据数据权限
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("kms_data_auth")
@CrmTable(name = "kms_data_auth", tableNote = "单据数据权限",indexes = {
        @Index(name = "kda_resp_data_id_index", columnList = "resp_data_id")
})
public class KmsDataAuthEntity extends CrmExtTenEntity<KmsDataAuthEntity> {
    private static final long serialVersionUID = -5658889324625276120L;

    /**
     * 原始数据ID
     */
    @CrmColumn(name = "resp_data_id", length = 64, note = "原始数据ID")
    private String respDataId;

    @CrmColumn(name = "bs_direct_system_id", length = 64, note = "直营体系ID")
    private String bsDirectSystemId;
}