package com.biz.crm.grabrule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @Project crm
 * @PackageName com.biz.crm.grabrule.model
 * @ClassName KmsRequestEntity
 * @Author Gavin
 * @Date 2021/4/21 下午4:28
 * @Description 抓单请求
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("test_kms_request")
@CrmTable(name = "test_kms_request", tableNote = "抓单请求")
public class KmsRequestEntity extends CrmExtTenEntity<KmsGrabRuleEntity> {

    private static final long serialVersionUID = -1276073503422905622L;

    /**
     * 文件和表单数据关联字段
     */
    @CrmColumn(name = "uuid", length = 64,note = "文件和表单数据关联字段")
    private String uuid;

    /**
     * 请求GRPC的信息
     */
    @CrmColumn(name = "request", mysqlType = "MEDIUMTEXT",oracleType = "CLOB",note = "请求数据")
    private String request;

    /**
     * 抓取发起时间
     */
    @CrmColumn(name = "time", mysqlType = "DATETIME",oracleType = "DATE",note = "抓取发起时间")
    private LocalDateTime time;

    /**
     * 是否为自动抓单（1-自动抓单，0-手动抓单）
     */
    @CrmColumn(name = "auto", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "是否为自动抓单（1-自动抓单，0-手动抓单）")
    private Integer auto;

    /**
     * 失败次数
     */
    @CrmColumn(name = "fail", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "失败次数")
    private Integer fail;

    /**
     * 抓取的结果
     */
    @CrmColumn(name = "response", length = 512, note = "抓取的结果")
    private String response;

    /**
     * 0-单线程，1-多线程
     */
    @CrmColumn(name = "method", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "0-单线程，1-多线程")
    private Integer method;

    /**
     * 0-数据，1-文件
     */
    @CrmColumn(name = "file", mysqlType = "int(11)", oracleType = "NUMBER(11,0)", note = "0-数据，1-文件")
    private Integer file;
}