package com.biz.crm.acceptanceform.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.acceptanceform.model.KmsAcceptanceFormEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.acceptanceform.req.KmsAcceptanceFormReqVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceFormExportRespVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;

/**
 * 转换后验收单
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
public interface KmsAcceptanceFormMapper extends BaseMapper<KmsAcceptanceFormEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsAcceptanceFormReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsAcceptanceFormRespVo> findList(Page<KmsAcceptanceFormRespVo> page, @Param("vo") KmsAcceptanceFormReqVo kmsAcceptanceFormReqVo);

    /**
     * 匹配条件 门店+商品+日期 未匹配验收单 商品纬度
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsAuditAcceptanceFormRespVo> findNotMatchedPDS(Page<KmsAuditAcceptanceFormRespVo> page, @Param("vo") KmsAcceptanceFormReqVo reqVo);

    /**
     * 匹配条件 门店+日期 未匹配验收单 非商品纬度
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsAuditAcceptanceFormRespVo> findNotMatchedDS(Page<KmsAuditAcceptanceFormRespVo> page, @Param("vo") KmsAcceptanceFormReqVo reqVo);

    /**
     * 匹配条件 门店+商品+日期 匹配验收单 商品纬度
     *
     * @param reqVo
     * @return
     */
    //@SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsAuditAcceptanceFormRespVo> findMatchedPDS(@Param("vo") KmsAcceptanceFormReqVo reqVo);

    /**
     * 匹配条件 门店+日期 匹配验收单 非商品纬度
     *
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsAuditAcceptanceFormRespVo> findMatchedDS(@Param("vo") KmsAcceptanceFormReqVo reqVo);

    /**
     * 匹配条件 门店+商品+日期 已匹配验收单数据信息 商品纬度
     *
     * @param reqVo
     * @return
     */
    List<KmsAuditAcceptanceFormRespVo> findMatchedSuccPDS(@Param("vo") KmsAcceptanceFormReqVo reqVo);

    /**
     * 匹配条件 门店+日期 已匹配验收单数据信息 非商品纬度
     *
     * @param reqVo
     * @return
     */
    List<KmsAuditAcceptanceFormRespVo> findMatchedSuccDS(@Param("vo") KmsAcceptanceFormReqVo reqVo);

    /**
     * 手动匹配查询待匹配验收单数据列表 商品纬度
     *
     * @param page
     * @param reqVo
     * @return
     */
    //@SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsAuditAcceptanceFormRespVo> findMatchedPDS(Page<KmsAuditAcceptanceFormRespVo> page, @Param("vo") KmsAcceptanceFormReqVo reqVo);

    /**
     * 查询已匹配验收单数据列表 商品纬度
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<KmsAuditAcceptanceFormRespVo> findMatchedSuccPDS(Page<KmsAuditAcceptanceFormRespVo> page, @Param("vo") KmsAcceptanceFormReqVo reqVo);

    /**
     * 手动匹配查询待匹配验收单数据列表 非商品纬度
     *
     * @param page
     * @param queryVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code",orgCode = "t.create_org_code")
    List<KmsAuditAcceptanceFormRespVo> findMatchedDS(Page<KmsAuditAcceptanceFormRespVo> page, @Param("vo") KmsAcceptanceFormReqVo queryVo);

    /**
     * 查询已匹配验收单数据列表 非商品纬度
     *
     * @param page
     * @param queryVo
     * @return
     */
    List<KmsAuditAcceptanceFormRespVo> findMatchedSuccDS(Page<KmsAuditAcceptanceFormRespVo> page, @Param("vo") KmsAcceptanceFormReqVo queryVo);

    /**
     * 列表导出
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsAcceptanceFormExportRespVo> findListForExport(Page<KmsAcceptanceFormExportRespVo> page, @Param("vo") KmsAcceptanceFormReqVo reqVo);

    /**
     * 查询验收单关联区域名称
     */
    List<KmsAcceptanceFormRespVo> findAreaName(@Param("ids")List<String> ids);
}
