package com.biz.crm.confadmin.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.service.IKmsInterfaceParamService;
import com.biz.crm.nebular.kms.confadmin.req.KmsInterfaceParamReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsInterfaceParamRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * kms抓单接口参数
 *
 * @author Gavin
 * @date 2021-05-07 10:20:19
 */
@Slf4j
@RestController
@RequestMapping("/kmsinterfaceparam")
@Api(tags = "KMS后台商超接口参数")
public class KmsInterfaceParamController {
    @Autowired
    private IKmsInterfaceParamService kmsInterfaceParamService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<KmsInterfaceParamRespVo>> list(@RequestBody KmsInterfaceParamReqVo kmsInterfaceParamReqVo) {
        PageResult<KmsInterfaceParamRespVo> result=kmsInterfaceParamService.findList(kmsInterfaceParamReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<KmsInterfaceParamRespVo> query(@RequestBody KmsInterfaceParamReqVo kmsInterfaceParamReqVo) {
        KmsInterfaceParamRespVo respVo=kmsInterfaceParamService.query(kmsInterfaceParamReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody KmsInterfaceParamReqVo kmsInterfaceParamReqVo) {
        kmsInterfaceParamService.save(kmsInterfaceParamReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody KmsInterfaceParamReqVo kmsInterfaceParamReqVo) {
        kmsInterfaceParamService.update(kmsInterfaceParamReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        KmsInterfaceParamReqVo kmsInterfaceParamReqVo = new KmsInterfaceParamReqVo();
        kmsInterfaceParamReqVo.setIds(ids);
        kmsInterfaceParamService.deleteBatch(kmsInterfaceParamReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody KmsInterfaceParamReqVo kmsInterfaceParamReqVo) {
        kmsInterfaceParamService.enableBatch(kmsInterfaceParamReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  KmsInterfaceParamReqVo kmsInterfaceParamReqVo) {
        kmsInterfaceParamService.disableBatch(kmsInterfaceParamReqVo);
        return Result.ok("禁用成功");
    }
}
