package com.biz.crm.confadmin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.confadmin.model.KmsDirectSystemEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectSystemReqVo;
import com.biz.crm.nebular.kms.confadmin.req.TenantryDirectReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectStoreRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectSystemRespVo;
import com.biz.crm.nebular.kms.confadmin.resp.TenantryDirectRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商超信息
 *
 * @author Gavin
 * @date 2021-05-06 13:51:45
 */
public interface KmsDirectSystemMapper extends BaseMapper<KmsDirectSystemEntity> {
    /**
     * 列表
     *
     * @param page
     * @param kmsDirectSystemReqVo
     * @return
     */
    List<KmsDirectSystemRespVo> findList(Page<KmsDirectSystemRespVo> page, @Param("vo") KmsDirectSystemReqVo kmsDirectSystemReqVo);

    /**
     * 获取客户开通商超（直营体系）信息
     * @param page
     * @param params
     * @return
     */
    List<TenantryDirectRespVo> findDirectList(Page<KmsDirectStoreRespVo> page, @Param("vo") TenantryDirectReqVo params);

    /**
     * 根据
     * @param kmsDirectSystemReqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsDirectSystemRespVo> findSystemListByCusOrg(Page<KmsDirectSystemRespVo> page,@Param("vo") KmsDirectSystemReqVo kmsDirectSystemReqVo);
}
