package com.biz.crm.confadmin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.model.KmsDirectSystemEntity;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectSystemReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectSystemRespVo;

import java.util.List;

/**
 * 商超信息接口
 *
 * @author Gavin
 * @date 2021-05-06 13:51:45
 */
public interface IKmsDirectSystemService extends IService<KmsDirectSystemEntity> {

    /**
     * 列表
     *
     * @param kmsDirectSystemReqVo
     * @return PageResult<KmsDirectSystemRespVo>
     */
    PageResult<KmsDirectSystemRespVo> findList(KmsDirectSystemReqVo kmsDirectSystemReqVo);

    /**
     * 查询
     *
     * @param id
     * @return KmsDirectSystemRespVo
     */
    KmsDirectSystemRespVo query(String id);

    /**
     * 新增
     *
     * @param kmsDirectSystemReqVo
     * @return
     */
    void save(KmsDirectSystemReqVo kmsDirectSystemReqVo);

    /**
     * 更新
     *
     * @param kmsDirectSystemReqVo
     * @return
     */
    void update(KmsDirectSystemReqVo kmsDirectSystemReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 根据直营体系查询商超
     * @return
     */
    PageResult<KmsDirectSystemRespVo> findDirectSystemList(KmsDirectSystemReqVo reqVo);
}

