package com.biz.crm.confadmin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.model.KmsDirectThreadEntity;
import com.biz.crm.nebular.kms.confadmin.req.KmsDirectThreadReqVo;
import com.biz.crm.nebular.kms.confadmin.resp.KmsDirectThreadRespVo;

import java.util.List;

/**
 * 商超单据抓取方式接口
 *
 * @author Gavin
 * @date 2021-05-06 15:12:00
 */
public interface IKmsDirectThreadService extends IService<KmsDirectThreadEntity> {

    /**
     * 列表
     *
     * @param kmsDirectThreadReqVo
     * @return PageResult<KmsDirectThreadRespVo>
     */
    PageResult<KmsDirectThreadRespVo> findList(KmsDirectThreadReqVo kmsDirectThreadReqVo);

    /**
     * 查询
     *
     * @param id
     * @return KmsDirectThreadRespVo
     */
    KmsDirectThreadRespVo query(String id);

    /**
     * 新增
     *
     * @param kmsDirectThreadReqVo
     * @return
     */
    void save(KmsDirectThreadReqVo kmsDirectThreadReqVo);

    /**
     * 更新
     *
     * @param kmsDirectThreadReqVo
     * @return
     */
    void update(KmsDirectThreadReqVo kmsDirectThreadReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

