package com.biz.crm.config;

import com.biz.crm.eunm.kms.KmsAuditConditionEnum;
import com.biz.crm.finance.annotation.KmsFunction;
import com.biz.crm.finance.funcation.KmsAuditFunction;
import com.biz.crm.finance.funcation.base.BaseAuditFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * @Project crm
 * @PackageName com.biz.crm.config
 * @ClassName KmsAuditConfig
 * @Author Gavin
 * @Date 2021/6/21 下午5:45
 * @Description 稽核条件
 */
@Configuration
public class KmsAuditConfig {
    @Autowired
    private ApplicationContext context;

    @Resource
    private KmsAuditFunction kmsAuditFunction;

    @PostConstruct
    public void init() {
        //获取所有函数
        Map<String, Object> map = context.getBeansWithAnnotation(KmsFunction.class);
        Map<KmsAuditConditionEnum, BaseAuditFunction> functionMap = new HashMap<>(100);
        for (Map.Entry<String,Object> key: map.entrySet()) {
            Object v = key.getValue();
            if(v instanceof BaseAuditFunction) {
                KmsFunction function = v.getClass().getAnnotation(KmsFunction.class);
                functionMap.put(function.code(),(BaseAuditFunction)v);
            }
        }
        this.kmsAuditFunction.setFunctionMap(functionMap);
    }
}